<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class INSTIVE_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	 */

	public static function get_icons() {

		$icons = array(
            'tsicon tsicon-plus-icon'               => 'tsicon tsicon-plus-icon',
            'tsicon tsicon-mobile'                  => 'tsicon tsicon-mobile',
            'tsicon tsicon-laptop'                  => 'tsicon tsicon-laptop',
            'tsicon tsicon-desktop'                 => 'tsicon tsicon-desktop',
            'tsicon tsicon-tablet'                  => 'tsicon tsicon-tablet',
            'tsicon tsicon-phone'                   => 'tsicon tsicon-phone',
            'tsicon tsicon-document'                => 'tsicon tsicon-document',
            'tsicon tsicon-documents'               => 'tsicon tsicon-documents',
            'tsicon tsicon-search'                  => 'tsicon tsicon-search',
            'tsicon tsicon-clipboard'               => 'tsicon tsicon-clipboard',
            'tsicon tsicon-newspaper'               => 'tsicon tsicon-newspaper',
            'tsicon tsicon-notebook'                => 'tsicon tsicon-notebook',
            'tsicon tsicon-book-open'               => 'tsicon tsicon-book-open',
            'tsicon tsicon-browser'                 => 'tsicon tsicon-browser',
            'tsicon tsicon-calendar'                => 'tsicon tsicon-calendar',
            'tsicon tsicon-presentation'            => 'tsicon tsicon-presentation',
            'tsicon tsicon-picture'                 => 'tsicon tsicon-picture',
            'tsicon tsicon-pictures'                => 'tsicon tsicon-pictures',
            'tsicon tsicon-video'                   => 'tsicon tsicon-video',
            'tsicon tsicon-camera'                  => 'tsicon tsicon-camera',
            'tsicon tsicon-printer'                 => 'tsicon tsicon-printer',
            'tsicon tsicon-toolbox'                 => 'tsicon tsicon-toolbox',
            'tsicon tsicon-briefcase'               => 'tsicon tsicon-briefcase',
            'tsicon tsicon-wallet'                  => 'tsicon tsicon-wallet',
            'tsicon tsicon-gift'                    => 'tsicon tsicon-gift',
            'tsicon tsicon-bargraph'                => 'tsicon tsicon-bargraph',
            'tsicon tsicon-grid'                    => 'tsicon tsicon-grid',
            'tsicon tsicon-expand'                  => 'tsicon tsicon-expand',
            'tsicon tsicon-focus'                   => 'tsicon tsicon-focus',
            'tsicon tsicon-edit'                    => 'tsicon tsicon-edit',
            'tsicon tsicon-adjustments'             => 'tsicon tsicon-adjustments',
            'tsicon tsicon-ribbon'                  => 'tsicon tsicon-ribbon',
            'tsicon tsicon-hourglass'               => 'tsicon tsicon-hourglass',
            'tsicon tsicon-lock'                    => 'tsicon tsicon-lock',
            'tsicon tsicon-megaphone'               => 'tsicon tsicon-megaphone',
            'tsicon tsicon-shield'                  => 'tsicon tsicon-shield',
            'tsicon tsicon-trophy'                  => 'tsicon tsicon-trophy',
            'tsicon tsicon-flag'                    => 'tsicon tsicon-flag',
            'tsicon tsicon-map'                     => 'tsicon tsicon-map',
            'tsicon tsicon-puzzle'                  => 'tsicon tsicon-puzzle',
            'tsicon tsicon-basket'                  => 'tsicon tsicon-basket',
            'tsicon tsicon-envelope'                => 'tsicon tsicon-envelope',
            'tsicon tsicon-streetsign'              => 'tsicon tsicon-streetsign',
            'tsicon tsicon-telescope'               => 'tsicon tsicon-telescope',
            'tsicon tsicon-gears'                   => 'tsicon tsicon-gears',
            'tsicon tsicon-key'                     => 'tsicon tsicon-key',
            'tsicon tsicon-paperclip'               => 'tsicon tsicon-paperclip',
            'tsicon tsicon-attachment'              => 'tsicon tsicon-attachment',
            'tsicon tsicon-pricetags'               => 'tsicon tsicon-pricetags',
            'tsicon tsicon-lightbulb'               => 'tsicon tsicon-lightbulb',
            'tsicon tsicon-layers'                  => 'tsicon tsicon-layers',
            'tsicon tsicon-pencil'                  => 'tsicon tsicon-pencil',
            'tsicon tsicon-tools'                   => 'tsicon tsicon-tools',
            'tsicon tsicon-tools-2'                 => 'tsicon tsicon-tools-2',
            'tsicon tsicon-scissors'                => 'tsicon tsicon-scissors',
            'tsicon tsicon-paintbrush'              => 'tsicon tsicon-paintbrush',
            'tsicon tsicon-magnifying-glass'        => 'tsicon tsicon-magnifying-glass',
            'tsicon tsicon-circle-compass'          => 'tsicon tsicon-circle-compass',
            'tsicon tsicon-linegraph'               => 'tsicon tsicon-linegraph',
            'tsicon tsicon-mic'                     => 'tsicon tsicon-mic',
            'tsicon tsicon-strategy'                => 'tsicon tsicon-strategy',
            'tsicon tsicon-beaker'                  => 'tsicon tsicon-beaker',
            'tsicon tsicon-caution'                 => 'tsicon tsicon-caution',
            'tsicon tsicon-recycle'                 => 'tsicon tsicon-recycle',
            'tsicon tsicon-anchor'                  => 'tsicon tsicon-anchor',
            'tsicon tsicon-profile-male'            => 'tsicon tsicon-profile-male',
            'tsicon tsicon-profile-female'          => 'tsicon tsicon-profile-female',
            'tsicon tsicon-bike'                    => 'tsicon tsicon-bike',
            'tsicon tsicon-wine'                    => 'tsicon tsicon-wine',
            'tsicon tsicon-hotairballoon'           => 'tsicon tsicon-hotairballoon',
            'tsicon tsicon-globe'                   => 'tsicon tsicon-globe',
            'tsicon tsicon-genius'                  => 'tsicon tsicon-genius',
            'tsicon tsicon-map-pin'                 => 'tsicon tsicon-map-pin',
            'tsicon tsicon-dial'                    => 'tsicon tsicon-dial',
            'tsicon tsicon-chat'                    => 'tsicon tsicon-chat',
            'tsicon tsicon-heart'                   => 'tsicon tsicon-heart',
            'tsicon tsicon-cloud'                   => 'tsicon tsicon-cloud',
            'tsicon tsicon-upload'                  => 'tsicon tsicon-upload',
            'tsicon tsicon-download'                => 'tsicon tsicon-download',
            'tsicon tsicon-target'                  => 'tsicon tsicon-target',
            'tsicon tsicon-hazardous'               => 'tsicon tsicon-hazardous',
            'tsicon tsicon-piechart'                => 'tsicon tsicon-piechart',
            'tsicon tsicon-speedometer'             => 'tsicon tsicon-speedometer',
            'tsicon tsicon-global'                  => 'tsicon tsicon-global',
            'tsicon tsicon-compass'                 => 'tsicon tsicon-compass',
            'tsicon tsicon-lifesaver'               => 'tsicon tsicon-lifesaver',
            'tsicon tsicon-clock'                   => 'tsicon tsicon-clock',
            'tsicon tsicon-aperture'                => 'tsicon tsicon-aperture',
            'tsicon tsicon-quote'                   => 'tsicon tsicon-quote',
            'tsicon tsicon-scope'                   => 'tsicon tsicon-scope',
            'tsicon tsicon-alarmclock'              => 'tsicon tsicon-alarmclock',
            'tsicon tsicon-refresh'                 => 'tsicon tsicon-refresh',
            'tsicon tsicon-happy'                   => 'tsicon tsicon-happy',
            'tsicon tsicon-sad'                     => 'tsicon tsicon-sad',
            'tsicon tsicon-facebook'                => 'tsicon tsicon-facebook',
            'tsicon tsicon-twitter'                 => 'tsicon tsicon-twitter',
            'tsicon tsicon-googleplus'              => 'tsicon tsicon-googleplus',
            'tsicon tsicon-rss'                     => 'tsicon tsicon-rss',
            'tsicon tsicon-tumblr'                  => 'tsicon tsicon-tumblr',
            'tsicon tsicon-linkedin'                => 'tsicon tsicon-linkedin',
            'tsicon tsicon-dribbble'                => 'tsicon tsicon-dribbble',
            'tsicon tsicon-home'                    => 'tsicon tsicon-home',
            'tsicon tsicon-apartment'               => 'tsicon tsicon-apartment',
            'tsicon tsicon-pencil1'                 => 'tsicon tsicon-pencil1',
            'tsicon tsicon-magic-wand'              => 'tsicon tsicon-magic-wand',
            'tsicon tsicon-drop'                    => 'tsicon tsicon-drop',
            'tsicon tsicon-lighter'                 => 'tsicon tsicon-lighter',
            'tsicon tsicon-poop'                    => 'tsicon tsicon-poop',
            'tsicon tsicon-sun'                     => 'tsicon tsicon-sun',
            'tsicon tsicon-moon'                    => 'tsicon tsicon-moon',
            'tsicon tsicon-cloud1'                  => 'tsicon tsicon-cloud1',
            'tsicon tsicon-cloud-upload'            => 'tsicon tsicon-cloud-upload',
            'tsicon tsicon-cloud-download'          => 'tsicon tsicon-cloud-download',
            'tsicon tsicon-cloud-sync'              => 'tsicon tsicon-cloud-sync',
            'tsicon tsicon-cloud-check'             => 'tsicon tsicon-cloud-check',
            'tsicon tsicon-database'                => 'tsicon tsicon-database',
            'tsicon tsicon-lock1'                   => 'tsicon tsicon-lock1',
            'tsicon tsicon-cog'                     => 'tsicon tsicon-cog',
            'tsicon tsicon-trash'                   => 'tsicon tsicon-trash',
            'tsicon tsicon-dice'                    => 'tsicon tsicon-dice',
            'tsicon tsicon-heart1'                  => 'tsicon tsicon-heart1',
            'tsicon tsicon-star'                    => 'tsicon tsicon-star',
            'tsicon tsicon-star-half'               => 'tsicon tsicon-star-half',
            'tsicon tsicon-star-empty'              => 'tsicon tsicon-star-empty',
            'tsicon tsicon-flag1'                   => 'tsicon tsicon-flag1',
            'tsicon tsicon-envelope1'               => 'tsicon tsicon-envelope1',
            'tsicon tsicon-paperclip1'              => 'tsicon tsicon-paperclip1',
            'tsicon tsicon-inbox'                   => 'tsicon tsicon-inbox',
            'tsicon tsicon-eye'                     => 'tsicon tsicon-eye',
            'tsicon tsicon-printer1'                => 'tsicon tsicon-printer1',
            'tsicon tsicon-file-empty'              => 'tsicon tsicon-file-empty',
            'tsicon tsicon-file-add'                => 'tsicon tsicon-file-add',
            'tsicon tsicon-enter'                   => 'tsicon tsicon-enter',
            'tsicon tsicon-exit'                    => 'tsicon tsicon-exit',
            'tsicon tsicon-graduation-hat'          => 'tsicon tsicon-graduation-hat',
            'tsicon tsicon-license'                 => 'tsicon tsicon-license',
            'tsicon tsicon-music-note'              => 'tsicon tsicon-music-note',
            'tsicon tsicon-film-play'               => 'tsicon tsicon-film-play',
            'tsicon tsicon-camera-video'            => 'tsicon tsicon-camera-video',
            'tsicon tsicon-camera1'                 => 'tsicon tsicon-camera1',
            'tsicon tsicon-picture1'                => 'tsicon tsicon-picture1',
            'tsicon tsicon-book'                    => 'tsicon tsicon-book',
            'tsicon tsicon-bookmark'                => 'tsicon tsicon-bookmark',
            'tsicon tsicon-user'                    => 'tsicon tsicon-user',
            'tsicon tsicon-users'                   => 'tsicon tsicon-users',
            'tsicon tsicon-shirt'                   => 'tsicon tsicon-shirt',
            'tsicon tsicon-store'                   => 'tsicon tsicon-store',
            'tsicon tsicon-cart'                    => 'tsicon tsicon-cart',
            'tsicon tsicon-tag'                     => 'tsicon tsicon-tag',
            'tsicon tsicon-phone-handset'           => 'tsicon tsicon-phone-handset',
            'tsicon tsicon-phone1'                  => 'tsicon tsicon-phone1',
            'tsicon tsicon-pushpin'                 => 'tsicon tsicon-pushpin',
            'tsicon tsicon-map-marker'              => 'tsicon tsicon-map-marker',
            'tsicon tsicon-map1'                    => 'tsicon tsicon-map1',
            'tsicon tsicon-location'                => 'tsicon tsicon-location',
            'tsicon tsicon-calendar-full'           => 'tsicon tsicon-calendar-full',
            'tsicon tsicon-keyboard'                => 'tsicon tsicon-keyboard',
            'tsicon tsicon-spell-check'             => 'tsicon tsicon-spell-check',
            'tsicon tsicon-screen'                  => 'tsicon tsicon-screen',
            'tsicon tsicon-smartphone'              => 'tsicon tsicon-smartphone',
            'tsicon tsicon-tablet1'                 => 'tsicon tsicon-tablet1',
            'tsicon tsicon-laptop1'                 => 'tsicon tsicon-laptop1',
            'tsicon tsicon-laptop-phone'            => 'tsicon tsicon-laptop-phone',
            'tsicon tsicon-power-switch'            => 'tsicon tsicon-power-switch',
            'tsicon tsicon-bubble'                  => 'tsicon tsicon-bubble',
            'tsicon tsicon-heart-pulse'             => 'tsicon tsicon-heart-pulse',
            'tsicon tsicon-construction'            => 'tsicon tsicon-construction',
            'tsicon tsicon-pie-chart'               => 'tsicon tsicon-pie-chart',
            'tsicon tsicon-chart-bars'              => 'tsicon tsicon-chart-bars',
            'tsicon tsicon-gift1'                   => 'tsicon tsicon-gift1',
            'tsicon tsicon-diamond'                 => 'tsicon tsicon-diamond',
            'tsicon tsicon-dinner'                  => 'tsicon tsicon-dinner',
            'tsicon tsicon-coffee-cup'              => 'tsicon tsicon-coffee-cup',
            'tsicon tsicon-leaf'                    => 'tsicon tsicon-leaf',
            'tsicon tsicon-paw'                     => 'tsicon tsicon-paw',
            'tsicon tsicon-rocket'                  => 'tsicon tsicon-rocket',
            'tsicon tsicon-briefcase1'              => 'tsicon tsicon-briefcase1',
            'tsicon tsicon-bus'                     => 'tsicon tsicon-bus',
            'tsicon tsicon-car'                     => 'tsicon tsicon-car',
            'tsicon tsicon-train'                   => 'tsicon tsicon-train',
            'tsicon tsicon-bicycle'                 => 'tsicon tsicon-bicycle',
            'tsicon tsicon-wheelchair'              => 'tsicon tsicon-wheelchair',
            'tsicon tsicon-select'                  => 'tsicon tsicon-select',
            'tsicon tsicon-earth'                   => 'tsicon tsicon-earth',
            'tsicon tsicon-smile'                   => 'tsicon tsicon-smile',
            'tsicon tsicon-sad1'                    => 'tsicon tsicon-sad1',
            'tsicon tsicon-neutral'                 => 'tsicon tsicon-neutral',
            'tsicon tsicon-mustache'                => 'tsicon tsicon-mustache',
            'tsicon tsicon-alarm'                   => 'tsicon tsicon-alarm',
            'tsicon tsicon-bullhorn'                => 'tsicon tsicon-bullhorn',
            'tsicon tsicon-volume-high'             => 'tsicon tsicon-volume-high',
            'tsicon tsicon-volume-medium'           => 'tsicon tsicon-volume-medium',
            'tsicon tsicon-volume-low'              => 'tsicon tsicon-volume-low',
            'tsicon tsicon-volume'                  => 'tsicon tsicon-volume',
            'tsicon tsicon-mic1'                    => 'tsicon tsicon-mic1',
            'tsicon tsicon-hourglass1'              => 'tsicon tsicon-hourglass1',
            'tsicon tsicon-undo'                    => 'tsicon tsicon-undo',
            'tsicon tsicon-redo'                    => 'tsicon tsicon-redo',
            'tsicon tsicon-sync'                    => 'tsicon tsicon-sync',
            'tsicon tsicon-history'                 => 'tsicon tsicon-history',
            'tsicon tsicon-clock1'                  => 'tsicon tsicon-clock1',
            'tsicon tsicon-download1'               => 'tsicon tsicon-download1',
            'tsicon tsicon-upload1'                 => 'tsicon tsicon-upload1',
            'tsicon tsicon-enter-down'              => 'tsicon tsicon-enter-down',
            'tsicon tsicon-exit-up'                 => 'tsicon tsicon-exit-up',
            'tsicon tsicon-bug'                     => 'tsicon tsicon-bug',
            'tsicon tsicon-code'                    => 'tsicon tsicon-code',
            'tsicon tsicon-link'                    => 'tsicon tsicon-link',
            'tsicon tsicon-unlink'                  => 'tsicon tsicon-unlink',
            'tsicon tsicon-thumbs-up'               => 'tsicon tsicon-thumbs-up',
            'tsicon tsicon-thumbs-down'             => 'tsicon tsicon-thumbs-down',
            'tsicon tsicon-magnifier'               => 'tsicon tsicon-magnifier',
            'tsicon tsicon-cross'                   => 'tsicon tsicon-cross',
            'tsicon tsicon-menu'                    => 'tsicon tsicon-menu',
            'tsicon tsicon-list'                    => 'tsicon tsicon-list',
            'tsicon tsicon-chevron-up'              => 'tsicon tsicon-chevron-up',
            'tsicon tsicon-chevron-down'            => 'tsicon tsicon-chevron-down',
            'tsicon tsicon-chevron-left'            => 'tsicon tsicon-chevron-left',
            'tsicon tsicon-chevron-right'           => 'tsicon tsicon-chevron-right',
            'tsicon tsicon-arrow-up'                => 'tsicon tsicon-arrow-up',
            'tsicon tsicon-arrow-down'              => 'tsicon tsicon-arrow-down',
            'tsicon tsicon-arrow-left'              => 'tsicon tsicon-arrow-left',
            'tsicon tsicon-arrow-right'             => 'tsicon tsicon-arrow-right',
            'tsicon tsicon-move'                    => 'tsicon tsicon-move',
            'tsicon tsicon-warning'                 => 'tsicon tsicon-warning',
            'tsicon tsicon-question-circle'         => 'tsicon tsicon-question-circle',
            'tsicon tsicon-menu-circle'             => 'tsicon tsicon-menu-circle',
            'tsicon tsicon-checkmark-circle'        => 'tsicon tsicon-checkmark-circle',
            'tsicon tsicon-cross-circle'            => 'tsicon tsicon-cross-circle',
            'tsicon tsicon-plus-circle'             => 'tsicon tsicon-plus-circle',
            'tsicon tsicon-circle-minus'            => 'tsicon tsicon-circle-minus',
            'tsicon tsicon-arrow-up-circle'         => 'tsicon tsicon-arrow-up-circle',
            'tsicon tsicon-arrow-down-circle'       => 'tsicon tsicon-arrow-down-circle',
            'tsicon tsicon-arrow-left-circle'       => 'tsicon tsicon-arrow-left-circle',
            'tsicon tsicon-arrow-right-circle'      => 'tsicon tsicon-arrow-right-circle',
            'tsicon tsicon-chevron-up-circle'       => 'tsicon tsicon-chevron-up-circle',
            'tsicon tsicon-chevron-down-circle'     => 'tsicon tsicon-chevron-down-circle',
            'tsicon tsicon-chevron-left-circle'     => 'tsicon tsicon-chevron-left-circle',
            'tsicon tsicon-chevron-right-circle'    => 'tsicon tsicon-chevron-right-circle',
            'tsicon tsicon-crop'                    => 'tsicon tsicon-crop',
            'tsicon tsicon-frame-expand'            => 'tsicon tsicon-frame-expand',
            'tsicon tsicon-frame-contract'          => 'tsicon tsicon-frame-contract',
            'tsicon tsicon-layers1'                 => 'tsicon tsicon-layers1',
            'tsicon tsicon-funnel'                  => 'tsicon tsicon-funnel',
            'tsicon tsicon-text-format'             => 'tsicon tsicon-text-format',
            'tsicon tsicon-text-size'               => 'tsicon tsicon-text-size',
            'tsicon tsicon-bold'                    => 'tsicon tsicon-bold',
            'tsicon tsicon-italic'                  => 'tsicon tsicon-italic',
            'tsicon tsicon-underline'               => 'tsicon tsicon-underline',
            'tsicon tsicon-strikethrough'           => 'tsicon tsicon-strikethrough',
            'tsicon tsicon-highlight'               => 'tsicon tsicon-highlight',
            'tsicon tsicon-text-align-left'         => 'tsicon tsicon-text-align-left',
            'tsicon tsicon-text-align-center'       => 'tsicon tsicon-text-align-center',
            'tsicon tsicon-text-align-right'        => 'tsicon tsicon-text-align-right',
            'tsicon tsicon-text-align-justify'      => 'tsicon tsicon-text-align-justify',
            'tsicon tsicon-line-spacing'            => 'tsicon tsicon-line-spacing',
            'tsicon tsicon-indent-increase'         => 'tsicon tsicon-indent-increase',
            'tsicon tsicon-indent-decrease'         => 'tsicon tsicon-indent-decrease',
            'tsicon tsicon-page-break'              => 'tsicon tsicon-page-break',
            'tsicon tsicon-hand'                    => 'tsicon tsicon-hand',
            'tsicon tsicon-pointer-up'              => 'tsicon tsicon-pointer-up',
            'tsicon tsicon-pointer-right'           => 'tsicon tsicon-pointer-right',
            'tsicon tsicon-pointer-down'            => 'tsicon tsicon-pointer-down',
            'tsicon tsicon-pointer-left'            => 'tsicon tsicon-pointer-left',
            'tsicon tsicon-icon01'                  => 'tsicon tsicon-icon01',
            'tsicon tsicon-doctor'                  => 'tsicon tsicon-doctor',
            'tsicon tsicon-car-accident-o'          => 'tsicon tsicon-car-accident-o',
            'tsicon tsicon-tv'                      => 'tsicon tsicon-tv',
            'tsicon tsicon-ambulance'               => 'tsicon tsicon-ambulance',
            'tsicon tsicon-ship-accident'           => 'tsicon tsicon-ship-accident',
            'tsicon tsicon-signal'                  => 'tsicon tsicon-signal',
            'tsicon tsicon-user-o'                  => 'tsicon tsicon-user-o',
            'tsicon tsicon-button_icon03'           => 'tsicon tsicon-button_icon03',
            'tsicon tsicon-button_icon04'           => 'tsicon tsicon-button_icon04',
            'tsicon tsicon-button_icon05'           => 'tsicon tsicon-button_icon05',
            'tsicon tsicon-cta_icon'                => 'tsicon tsicon-cta_icon',
            'tsicon tsicon-feature_icon01'          => 'tsicon tsicon-feature_icon01',
            'tsicon tsicon-feature_icon02'          => 'tsicon tsicon-feature_icon02',
            'tsicon tsicon-feature_icon03'          => 'tsicon tsicon-feature_icon03',
            'tsicon tsicon-dollar'                  => 'tsicon tsicon-dollar',
            'tsicon tsicon-user-fill'               => 'tsicon tsicon-user-fill',
            'tsicon tsicon-envelop-fill'            => 'tsicon tsicon-envelop-fill',
            'tsicon tsicon-building'                => 'tsicon tsicon-building',
            'tsicon tsicon-form_icon04'             => 'tsicon tsicon-form_icon04',
            'tsicon tsicon-car-accident'            => 'tsicon tsicon-car-accident',
            'tsicon tsicon-user-group'              => 'tsicon tsicon-user-group',
            'tsicon tsicon-dental'                  => 'tsicon tsicon-dental',
            'tsicon tsicon-house'                   => 'tsicon tsicon-house',
            'tsicon tsicon-balloon'                 => 'tsicon tsicon-balloon',
            'tsicon tsicon-paper-plane'             => 'tsicon tsicon-paper-plane',
            'tsicon tsicon-icon031'                 => 'tsicon tsicon-icon031',
            'tsicon tsicon-v-sign'                  => 'tsicon tsicon-v-sign',
            'tsicon tsicon-heart-o'                 => 'tsicon tsicon-heart-o',
            'tsicon tsicon-icon032'                 => 'tsicon tsicon-icon032',
            'tsicon tsicon-plane'                   => 'tsicon tsicon-plane',
            'tsicon tsicon-icon051'                 => 'tsicon tsicon-icon051',
            'tsicon tsicon-ship'                    => 'tsicon tsicon-ship',
            'tsicon tsicon-trolly'                  => 'tsicon tsicon-trolly',
            'tsicon tsicon-icon08'                  => 'tsicon tsicon-icon08',
            'tsicon tsicon-chair'                   => 'tsicon tsicon-chair',
            'tsicon tsicon-About2'                  => 'tsicon tsicon-About2',
            'tsicon tsicon-About3'                  => 'tsicon tsicon-About3',
            'tsicon tsicon-About4'                  => 'tsicon tsicon-About4',
            'tsicon tsicon-About'                   => 'tsicon tsicon-About',
            'tsicon tsicon-Banner_current'          => 'tsicon tsicon-Banner_current',
            'tsicon tsicon-Banner_factory1'         => 'tsicon tsicon-Banner_factory1',
            'tsicon tsicon-Banner_factory'          => 'tsicon tsicon-Banner_factory',
            'tsicon tsicon-Banner_pumpjack'         => 'tsicon tsicon-Banner_pumpjack',
            'tsicon tsicon-Funfacts2'               => 'tsicon tsicon-Funfacts2',
            'tsicon tsicon-Funfacts3'               => 'tsicon tsicon-Funfacts3',
            'tsicon tsicon-Funfacts4'               => 'tsicon tsicon-Funfacts4',
            'tsicon tsicon-Funfacts'                => 'tsicon tsicon-Funfacts',
            'tsicon tsicon-vplay'                   => 'tsicon tsicon-vplay',
            'tsicon tsicon-newsletter'              => 'tsicon tsicon-newsletter',
            'tsicon tsicon-coins-2'                 => 'tsicon tsicon-coins-2',
            'tsicon tsicon-commerce-2'              => 'tsicon tsicon-commerce-2',
            'tsicon tsicon-monitor'                 => 'tsicon tsicon-monitor',
            'tsicon tsicon-graphic-3'               => 'tsicon tsicon-graphic-3',
            'tsicon tsicon-business'                => 'tsicon tsicon-business',
            'tsicon tsicon-graphic-2'               => 'tsicon tsicon-graphic-2',
            'tsicon tsicon-commerce-1'              => 'tsicon tsicon-commerce-1',
            'tsicon tsicon-hammer'                  => 'tsicon tsicon-hammer',
            'tsicon tsicon-graphic-1'               => 'tsicon tsicon-graphic-1',
            'tsicon tsicon-graphic'                 => 'tsicon tsicon-graphic',
            'tsicon tsicon-justice-1'               => 'tsicon tsicon-justice-1',
            'tsicon tsicon-line'                    => 'tsicon tsicon-line',
            'tsicon tsicon-money-3'                 => 'tsicon tsicon-money-3',
            'tsicon tsicon-chart'                   => 'tsicon tsicon-chart',
            'tsicon tsicon-commerce'                => 'tsicon tsicon-commerce',
            'tsicon tsicon-agenda'                  => 'tsicon tsicon-agenda',
            'tsicon tsicon-money-2'                 => 'tsicon tsicon-money-2',
            'tsicon tsicon-justice'                 => 'tsicon tsicon-justice',
            'tsicon tsicon-money-1'                 => 'tsicon tsicon-money-1',
            'tsicon tsicon-money'                   => 'tsicon tsicon-money',
            'tsicon tsicon-technology'              => 'tsicon tsicon-technology',
            'tsicon tsicon-coins-1'                 => 'tsicon tsicon-coins-1',
            'tsicon tsicon-coins'                   => 'tsicon tsicon-coins',
            'tsicon tsicon-left-arrow'              => 'tsicon tsicon-left-arrow',
            'tsicon tsicon-bank'                    => 'tsicon tsicon-bank',
            'tsicon tsicon-calculator'              => 'tsicon tsicon-calculator',
            'tsicon tsicon-chart1'                  => 'tsicon tsicon-chart1',
            'tsicon tsicon-chart2'                  => 'tsicon tsicon-chart2',
            'tsicon tsicon-checked'                 => 'tsicon tsicon-checked',
            'tsicon tsicon-clock2'                  => 'tsicon tsicon-clock2',
            'tsicon tsicon-comment'                 => 'tsicon tsicon-comment',
            'tsicon tsicon-comments'                => 'tsicon tsicon-comments',
            'tsicon tsicon-consult'                 => 'tsicon tsicon-consult',
            'tsicon tsicon-consut2'                 => 'tsicon tsicon-consut2',
            'tsicon tsicon-deal'                    => 'tsicon tsicon-deal',
            'tsicon tsicon-download2'               => 'tsicon tsicon-download2',
            'tsicon tsicon-envelope2'               => 'tsicon tsicon-envelope2',
            'tsicon tsicon-euro'                    => 'tsicon tsicon-euro',
            'tsicon tsicon-folder'                  => 'tsicon tsicon-folder',
            'tsicon tsicon-invest'                  => 'tsicon tsicon-invest',
            'tsicon tsicon-loan'                    => 'tsicon tsicon-loan',
            'tsicon tsicon-map-marker1'             => 'tsicon tsicon-map-marker1',
            'tsicon tsicon-mutual-fund'             => 'tsicon tsicon-mutual-fund',
            'tsicon tsicon-percent'                 => 'tsicon tsicon-percent',
            'tsicon tsicon-phone2'                  => 'tsicon tsicon-phone2',
            'tsicon tsicon-pie-chart1'              => 'tsicon tsicon-pie-chart1',
            'tsicon tsicon-play'                    => 'tsicon tsicon-play',
            'tsicon tsicon-left-arrow2'             => 'tsicon tsicon-left-arrow2',
            'tsicon tsicon-savings'                 => 'tsicon tsicon-savings',
            'tsicon tsicon-search1'                 => 'tsicon tsicon-search1',
            'tsicon tsicon-tag1'                    => 'tsicon tsicon-tag1',
            'tsicon tsicon-tags'                    => 'tsicon tsicon-tags',
            'tsicon tsicon-tax'                     => 'tsicon tsicon-tax',
            'tsicon tsicon-quote1'                  => 'tsicon tsicon-quote1',
            'tsicon tsicon-right-arrow2'            => 'tsicon tsicon-right-arrow2',
            'tsicon tsicon-strategicservices_icon1' => 'tsicon tsicon-strategicservices_icon1',
            'tsicon tsicon-strategicservices_icon3' => 'tsicon tsicon-strategicservices_icon3',
            'tsicon tsicon-strategicservices_icon4' => 'tsicon tsicon-strategicservices_icon4',
            'tsicon tsicon-strategicservices_icon5' => 'tsicon tsicon-strategicservices_icon5',
            'tsicon tsicon-strategicservices_icon6' => 'tsicon tsicon-strategicservices_icon6',
            'tsicon tsicon-strategicservices_icon7' => 'tsicon tsicon-strategicservices_icon7',
            'tsicon tsicon-strategicservices_icon8' => 'tsicon tsicon-strategicservices_icon8',
            'tsicon tsicon-post_icon1'              => 'tsicon tsicon-post_icon1',
            'tsicon tsicon-post_icon2'              => 'tsicon tsicon-post_icon2',
            'tsicon tsicon-post_icon3'              => 'tsicon tsicon-post_icon3',
            'tsicon tsicon-post_icon4'              => 'tsicon tsicon-post_icon4',
            'tsicon tsicon-post_icon5'              => 'tsicon tsicon-post_icon5',
            'tsicon tsicon-application_icon'        => 'tsicon tsicon-application_icon',
            'tsicon tsicon-opened_positions_icon1'  => 'tsicon tsicon-opened_positions_icon1',
            'tsicon tsicon-opened_positions_icon2'  => 'tsicon tsicon-opened_positions_icon2',
            'tsicon tsicon-about_us_icon1'          => 'tsicon tsicon-about_us_icon1',
            'tsicon tsicon-about_us_icon2'          => 'tsicon tsicon-about_us_icon2',
            'tsicon tsicon-about_us_icon3'          => 'tsicon tsicon-about_us_icon3',
            'tsicon tsicon-about_us_icon4'          => 'tsicon tsicon-about_us_icon4',
            'tsicon tsicon-zoom-in'                 => 'tsicon tsicon-zoom-in',
            //  New Icons
            'tsicon tsicon-network'                 => 'tsicon tsicon-network',
            'tsicon tsicon-benefit_icon_4'          => 'tsicon tsicon-benefit_icon_4',
            'tsicon tsicon-benefit_icon_5'          => 'tsicon tsicon-benefit_icon_5',
            'tsicon tsicon-benefit_icon_6'          => 'tsicon tsicon-benefit_icon_6',
            'tsicon tsicon-benefit_icon_7'          => 'tsicon tsicon-benefit_icon_7',
            'tsicon tsicon-benefit_icon_8'          => 'tsicon tsicon-benefit_icon_8',
            'tsicon tsicon-best_offer_icon1'        => 'tsicon tsicon-best_offer_icon1',
            'tsicon tsicon-best_offer_icon2'        => 'tsicon tsicon-best_offer_icon2',
            'tsicon tsicon-call_add'                => 'tsicon tsicon-call_add',
            'tsicon tsicon-companies'               => 'tsicon tsicon-companies',
            'tsicon tsicon-contact_icon_2'          => 'tsicon tsicon-contact_icon_2',
            'tsicon tsicon-contact_icon_3'          => 'tsicon tsicon-contact_icon_3',
            'tsicon tsicon-cover_icon_1'            => 'tsicon tsicon-cover_icon_1',
            'tsicon tsicon-cover_icon_2'            => 'tsicon tsicon-cover_icon_2',
            'tsicon tsicon-cover_icon_3'            => 'tsicon tsicon-cover_icon_3',
            'tsicon tsicon-cover_icon_4'            => 'tsicon tsicon-cover_icon_4',
            'tsicon tsicon-cover_icon_5'            => 'tsicon tsicon-cover_icon_5',
            'tsicon tsicon-cover_icon_6'            => 'tsicon tsicon-cover_icon_6',
            'tsicon tsicon-credit-card'             => 'tsicon tsicon-credit-card',
            'tsicon tsicon-critical_illness_icon'   => 'tsicon tsicon-critical_illness_icon',
            'tsicon tsicon-customer'                => 'tsicon tsicon-customer',
            'tsicon tsicon-fixed_benefit_icon_1'    => 'tsicon tsicon-fixed_benefit_icon_1',
            'tsicon tsicon-fixed_benefit_icon_2'    => 'tsicon tsicon-fixed_benefit_icon_2',
            'tsicon tsicon-indeminity_plan_icon'    => 'tsicon tsicon-indeminity_plan_icon',
            'tsicon tsicon-insurance'               => 'tsicon tsicon-insurance',
            'tsicon tsicon-join_our_team'           => 'tsicon tsicon-join_our_team',
            'tsicon tsicon-left-arrow3'             => 'tsicon tsicon-left-arrow3',
            'tsicon tsicon-life_dream'              => 'tsicon tsicon-life_dream',
            'tsicon tsicon-lives_covered_icon'      => 'tsicon tsicon-lives_covered_icon',
            'tsicon tsicon-medal-star'              => 'tsicon tsicon-medal-star',
            'tsicon tsicon-messages'                => 'tsicon tsicon-messages',
            'tsicon tsicon-our_benefit'             => 'tsicon tsicon-our_benefit',
            'tsicon tsicon-our_faq'                 => 'tsicon tsicon-our_faq',
            'tsicon tsicon-our_protection_icon'     => 'tsicon tsicon-our_protection_icon',
            'tsicon tsicon-our_reason'              => 'tsicon tsicon-our_reason',
            'tsicon tsicon-Our_story'               => 'tsicon tsicon-Our_story',
            'tsicon tsicon-our_team'                => 'tsicon tsicon-our_team',
            'tsicon tsicon-plan_icon_1'             => 'tsicon tsicon-plan_icon_1',
            'tsicon tsicon-plan_icon_2'             => 'tsicon tsicon-plan_icon_2',
            'tsicon tsicon-plan_icon_3'             => 'tsicon tsicon-plan_icon_3',
            'tsicon tsicon-review'                  => 'tsicon tsicon-review',
            'tsicon tsicon-right-arrow3'            => 'tsicon tsicon-right-arrow3',
            'tsicon tsicon-team_services_benefit'   => 'tsicon tsicon-team_services_benefit',
            'tsicon tsicon-testimonial_icon'        => 'tsicon tsicon-testimonial_icon',
            'tsicon tsicon-top_up_health_icon_1'    => 'tsicon tsicon-top_up_health_icon_1',
            'tsicon tsicon-top_up_health_icon_3'    => 'tsicon tsicon-top_up_health_icon_3',
            'tsicon tsicon-top_up_plan_icon'        => 'tsicon tsicon-top_up_plan_icon',
            'tsicon tsicon-what_covered_icon'       => 'tsicon tsicon-what_covered_icon',
            'tsicon tsicon-why_do_i_need_1'         => 'tsicon tsicon-why_do_i_need_1',
            'tsicon tsicon-why_need_1'              => 'tsicon tsicon-why_need_1',
            'tsicon tsicon-why_need_2'              => 'tsicon tsicon-why_need_2',
            'tsicon tsicon-why_need_3'              => 'tsicon tsicon-why_need_3',
            'tsicon tsicon-why_need_4'              => 'tsicon tsicon-why_need_4',
            'tsicon tsicon-why_need_5'              => 'tsicon tsicon-why_need_5',
            'tsicon tsicon-why_need_icon_2'         => 'tsicon tsicon-why_need_icon_2',
            'tsicon tsicon-why_need_icon_3'         => 'tsicon tsicon-why_need_icon_3',
            'tsicon tsicon-about_us'                => 'tsicon tsicon-about_us',
            'tsicon tsicon-award'                   => 'tsicon tsicon-award',
            'tsicon tsicon-benefit_icon_1'          => 'tsicon tsicon-benefit_icon_1',
            'tsicon tsicon-benefit_icon_2'          => 'tsicon tsicon-benefit_icon_2',
            'tsicon tsicon-benefit_icon_3'          => 'tsicon tsicon-benefit_icon_3',
		);

		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">

				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'instive' ); ?>">

					<option value=""><?php esc_html_e( 'Select Icon', 'instive' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}

}
